/*
 * Decompiled with CFR 0.152.
 */
package com.momosoftworks.coldsweat.api.temperature.block_temp;

import com.momosoftworks.coldsweat.api.temperature.block_temp.BlockTemp;
import java.util.Collection;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class BlockTempConfig
extends BlockTemp {
    Map<String, Predicate<BlockState>> predicates;

    public BlockTempConfig(double minEffect, double maxEffect, double minTemp, double maxTemp, double range, boolean fade, Map<String, Predicate<BlockState>> predicates, Block ... blocks) {
        super(minEffect, maxEffect, minTemp, maxTemp, range, fade, blocks);
        this.predicates = predicates;
    }

    @Override
    public boolean isValid(Level level, BlockPos pos, BlockState state) {
        if (this.predicates.isEmpty()) {
            return true;
        }
        for (Predicate<BlockState> predicate : this.predicates.values()) {
            if (predicate.test(state)) continue;
            return false;
        }
        return true;
    }

    public boolean comparePredicates(BlockTempConfig other) {
        return this.predicates.keySet().equals(other.predicates.keySet());
    }

    public Collection<String> getPredicates() {
        return this.predicates.keySet();
    }
}

